/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.theme.ColorManager;
import com.aptana.theme.IControlThemerFactory;
import com.aptana.theme.IThemeManager;
import com.aptana.theme.Theme;
import com.aptana.theme.internal.ControlThemerFactory;
import com.aptana.theme.internal.InvasiveThemeHijacker;
import com.aptana.theme.internal.ThemeManager;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class ThemePlugin
extends AbstractUIPlugin {
    public static final String IBEAM_BLACK = "/icons/ibeam-black.gif";
    public static final String IBEAM_WHITE = "/icons/ibeam-white.gif";
    public static final String PLUGIN_ID = "com.aptana.theme";
    private static ThemePlugin plugin;
    private InvasiveThemeHijacker themeHijacker;
    private ColorManager fColorManager;
    private IControlThemerFactory fControlThemerFactory;
    private boolean fApplyThemeToAllEditors;
    private IEclipsePreferences.IPreferenceChangeListener fThemeChangeListener;
    private IEclipsePreferences.IPreferenceChangeListener fEclipseColorsListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Job job = new Job("Initializing theme plugin..."){

            protected IStatus run(IProgressMonitor monitor) {
                ThemePlugin.this.fThemeChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

                    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                        if ("apply_to_all_editors".equals(event.getKey())) {
                            ThemePlugin.this.fApplyThemeToAllEditors = Platform.getPreferencesService().getBoolean(ThemePlugin.PLUGIN_ID, "apply_to_all_editors", false, null);
                        }
                    }
                };
                InstanceScope.INSTANCE.getNode(ThemePlugin.PLUGIN_ID).addPreferenceChangeListener(ThemePlugin.this.fThemeChangeListener);
                ThemePlugin.this.fApplyThemeToAllEditors = Platform.getPreferencesService().getBoolean(ThemePlugin.PLUGIN_ID, "apply_to_all_editors", false, null);
                ThemePlugin.this.themeHijacker = new InvasiveThemeHijacker();
                ThemePlugin.this.themeHijacker.apply();
                ThemePlugin.this.fEclipseColorsListener = new EditorColorSyncher();
                InstanceScope.INSTANCE.getNode("org.eclipse.ui.editors").addPreferenceChangeListener(ThemePlugin.this.fEclipseColorsListener);
                ThemePlugin.this.revertConsoleColors();
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule();
    }

    private void revertConsoleColors() {
        boolean reverted = Platform.getPreferencesService().getBoolean(PLUGIN_ID, "reverted_console", false, null);
        if (reverted) {
            return;
        }
        UIUtils.getDisplay().asyncExec(new Runnable(){

            public void run() {
                IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.debug.ui");
                prefs.remove("org.eclipse.debug.ui.errorColor");
                prefs.remove("org.eclipse.debug.ui.outColor");
                prefs.remove("org.eclipse.debug.ui.inColor");
                prefs.remove("org.eclipse.debug.ui.consoleBackground");
                prefs.remove("org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND");
                try {
                    prefs.flush();
                    IEclipsePreferences themePrefs = InstanceScope.INSTANCE.getNode(ThemePlugin.PLUGIN_ID);
                    themePrefs.putBoolean("reverted_console", true);
                    try {
                        themePrefs.flush();
                    }
                    catch (BackingStoreException e) {
                        IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
                    }
                }
                catch (BackingStoreException e) {
                    IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.fThemeChangeListener != null) {
                InstanceScope.INSTANCE.getNode(PLUGIN_ID).removePreferenceChangeListener(this.fThemeChangeListener);
                this.fThemeChangeListener = null;
            }
            if (this.fEclipseColorsListener != null) {
                InstanceScope.INSTANCE.getNode("org.eclipse.ui.editors").removePreferenceChangeListener(this.fEclipseColorsListener);
                this.fEclipseColorsListener = null;
            }
            if (this.themeHijacker != null) {
                this.themeHijacker.dispose();
            }
            if (this.fColorManager != null) {
                this.fColorManager.dispose();
            }
            if (this.fControlThemerFactory != null) {
                this.fControlThemerFactory.dispose();
            }
        }
        finally {
            this.themeHijacker = null;
            this.fColorManager = null;
            this.fControlThemerFactory = null;
            plugin = null;
            super.stop(context);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(IBEAM_BLACK, ThemePlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)IBEAM_BLACK));
        reg.put(IBEAM_WHITE, ThemePlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)IBEAM_WHITE));
    }

    public static ThemePlugin getDefault() {
        return plugin;
    }

    public synchronized ColorManager getColorManager() {
        if (this.fColorManager == null) {
            this.fColorManager = new ColorManager();
        }
        return this.fColorManager;
    }

    public IThemeManager getThemeManager() {
        return ThemeManager.instance();
    }

    public synchronized IControlThemerFactory getControlThemerFactory() {
        if (this.fControlThemerFactory == null) {
            this.fControlThemerFactory = new ControlThemerFactory();
        }
        return this.fControlThemerFactory;
    }

    public static synchronized boolean applyToViews() {
        return false;
    }

    public static synchronized boolean applyToAllEditors() {
        return plugin == null ? false : ThemePlugin.plugin.fApplyThemeToAllEditors;
    }

    private final class EditorColorSyncher
    implements IEclipsePreferences.IPreferenceChangeListener {
        private EditorColorSyncher() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            RGB existing;
            RGB value;
            String newValue;
            if (!ThemePlugin.applyToAllEditors()) {
                return;
            }
            if ("AbstractTextEditor.Color.Foreground".equals(event.getKey())) {
                RGB existing2;
                RGB value2;
                String newValue2 = (String)event.getNewValue();
                if (newValue2 != null && !(value2 = StringConverter.asRGB((String)newValue2)).equals((Object)(existing2 = this.getCurrentTheme().getForeground()))) {
                    this.getCurrentTheme().updateFG(value2);
                }
            } else if ("AbstractTextEditor.Color.Background".equals(event.getKey())) {
                RGB existing3;
                RGB value3;
                String newValue3 = (String)event.getNewValue();
                if (newValue3 != null && !(value3 = StringConverter.asRGB((String)newValue3)).equals((Object)(existing3 = this.getCurrentTheme().getBackground()))) {
                    this.getCurrentTheme().updateBG(value3);
                }
            } else if ("AbstractTextEditor.Color.SelectionBackground".equals(event.getKey())) {
                RGB existing4;
                RGB value4;
                String newValue4 = (String)event.getNewValue();
                if (newValue4 != null && !(value4 = StringConverter.asRGB((String)newValue4)).equals((Object)(existing4 = this.getCurrentTheme().getSelectionAgainstBG()))) {
                    this.getCurrentTheme().updateSelection(value4);
                }
            } else if ("currentLineColor".equals(event.getKey()) && (newValue = (String)event.getNewValue()) != null && !(value = StringConverter.asRGB((String)newValue)).equals((Object)(existing = this.getCurrentTheme().getLineHighlightAgainstBG()))) {
                this.getCurrentTheme().updateLineHighlight(value);
            }
        }

        protected Theme getCurrentTheme() {
            return ThemePlugin.this.getThemeManager().getCurrentTheme();
        }
    }
}

